### Création de cartes de champ électrostatique
### créé par une ou deux particules chargées
### (Seules la direction et le sens sont affichés)

import numpy as np
import matplotlib.pylab as plt

### Constantes du problème
xmin,ymin,xmax,ymax=-2,-2,2.125,2.125	# Taille de la zone en m
h=0.25					# Pas de la zone en m
K=8.99E9				# Constante de Coulomb en USI
e=1.60E-19				# Charge élémentaire en C

### Coordonnées (x,y) des points de calcul
XX=np.arange(xmin,xmax,h)
YY=np.arange(ymin,ymax,h)
x,y=np.meshgrid(XX,YY)

### Initialisation
Ex2=None

####################################
##### À compléter : question 2 #####
### Champ créé par deux charges ####
####################################

### Particule 1
q1=-e	# Charge électrique
x1=-1	# Abscisse en m
y1=0	# Ordonnée en m

### Distance entre particule 1 et point (x,y)
r1=((x-x1)**2+(y-y1)**2)**0.5
 
### Coordonnée radiale champ E1 
E1=K*q1/r1**2

### Coordonnées vecteur unitaire 1
ux1=(x-x1)/r1
uy1=(y-y1)/r1

### Coordonnées cartésiennes champ E1 
Ex1=E1*ux1
Ey1=E1*uy1

####################################
### Fin de la partie à compléter ###
####################################

### Coordonnées du champ E
if Ex2 is None:  
    Ex=Ex1 
    Ey=Ey1
else:
    Ex=Ex1+Ex2
    Ey=Ey1+Ey2

### Norme des vecteurs E
E=(Ex**2+Ey**2)**0.5     

### vecteur E normalisé 
### (pour avoir des flèches de taille identique)
Ex=Ex/E
Ey=Ey/E

### Positions des différentes particules sources
if Ex2 is None :
    X_particules=np.array([x1])
    Y_particules=np.array([y1])
else :
    X_particules=np.array([x1,x2])
    Y_particules=np.array([y1,y2])

### Tracé des vecteurs normalisés
plt.rcParams['axes.formatter.use_locale'] = True
plt.figure(1, figsize=(5, 5))
plt.quiver(x,y,Ex,Ey)
plt.plot(X_particules,Y_particules,"r.",label="Particule(s)")
plt.legend(loc='upper right')
plt.xlabel("x (m)")
plt.ylabel("y (m)")
plt.title("Directions et sens du champ électrostatique")
plt.show()
