﻿# ##########################################################################
# Programme Python permettant de tracer les représentations spatiales
# et temporelles d'une onde


# le programme affiche les représentations spatiales et temporelles d'une onde sinusoïdale.
# l'élève doit:
#    - saisir la formule donnant la longueur d'onde
#    - adapter à la représentation spaciale l'expression y(t) de la représentation temporelle
#    - tracer y=f(t) et y=f(x)
#    - mesurer sur les bonnes courbes T et Lambda
#    - calculer la célérité
#    - les réponses sont affichées quand la fenêtre matplotlib se ferme

# comme T et V sont choisis aléatoirement, on peut recommencer l'exercice à l'infini...

import numpy as np
import matplotlib.pyplot as plt
import random

# ##############################
# initialisation des variables #
# ##############################
# période en seconde
# on tire T au hasard entre 0.02 et 1s (par pas de 0.01 s)
T=0.01+(random.randrange(1,100)/100)

# amplitude en m
A=2

# célerité en m/s
# on tire v au hasard entre 0.1 et 5 m/s (par pas de 0.1 m/s)
v= random.randrange(1,50)/10

""" TRAVAIL DES ÉLÈVES: """
# Exprimer la longueur d'onde à partir des données précédentes.
# attention: lambda (tout en minuscule) est un mot clé de python et ne peut pas être utilisé comme nom de variable.
# utiliser comme nom de variable: Lambda
Lambda=v*T
""" FIN TRAVAIL DES ÉLÈVES: """

# ################################
# Tracé
# ################################
# 1. Répresentation temporelle
# ################################

# on sépare la figure subplot en colonnes (subplot 12)
# et on se place sur celle de gauche : le dernier "1" de subplot(121)
plt.subplot(121)

# on crée un tableau avec 200 dates réparties entre 0 et 4 périodes
t=np.linspace(0,4*T,200)

""" TRAVAIL DES ÉLÈVES """
# on crée l'expression de l'ordonnée d'un point du milieu en fonction de la date t
y= A*np.cos(2*np.pi*(t/T))

# tracer y en fonction de t en bleu continu
plt.plot(t,y,"b-")
# nommer les axes et le graphique. mettre une grille
plt.xlabel("date t")
plt.ylabel("ordonnée d'un point (abscisse fixée)")
plt.title("Rerpésentation temporelle d'un signal périodique")
plt.grid()
""" FIN TRAVAIL DES ÉLÈVES: """

# ################################
# 2. Répresentation spatiale
# ################################
# on sépare la figure subplot en colonnes (subplot 12)
# et on se place sur celle de droite : le dernier "2" de subplot(122)
plt.subplot(122)

# on crée un tableau avec 200 positions réparties entre 0 et 4 LONGUEURS D'ONDES
x=np.linspace(0,3*Lambda,200)

""" TRAVAIL DES ÉLÈVES """
# Créer l'expression de l'ordonnée d'un point du milieu en fonction de son abscisse x
# pour cela, ADAPTER l'expression donnée pour la représentation temporelle: y= A*np.cos(2*np.pi*(t/T))
y= A*np.cos(2*np.pi*(x/Lambda))


# tracer y en fonction de x en rouge continu
plt.plot(x,y,"r-")
# nommer les axes et le graphique. mettre une grille
plt.xlabel("abscisse x")
plt.ylabel("ordonnée d'un point (date fixée)")
plt.title("Représentation spatiale d'un signal périodique")
plt.grid()
""" FIN TRAVAIL DES ÉLÈVES: """


# on affiche la fenêtre
plt.show()

# et quand la fenêtre Matplotlib se ferme, on affiche les réponses
print("La période vaut T=",T,"s")
print("La longueur d'onde vaut",chr(955),"=",Lambda,"m")    # chr(955) affiche la lettre grecque lambda
print("La célérité vaut v=",v,"m/s")
